var FP_STOPPED    = 0;
var FP_PLAYING    = 1;

var FP_CONTACTING = -1;
var FP_BUFFERING  = -1;
var FP_PAUSED     = -1;
var FP_SEEKING    = -1;

var FP_inNetscape45 = (navigator.appName == 'Netscape' && parseInt(navigator.appVersion) < 5);
var FP_inIe4 = (navigator.appName == "Microsoft Internet Explorer" && parseInt(navigator.appVersion) >= 4);
var FP_inNetscape6 = (navigator.appName == 'Netscape' && parseInt(navigator.appVersion) >= 5);
var FP_unsupportedBrowser = (!(FP_inNetscape45 || FP_inIe4 || FP_inNetscape6));

var FP_debug = true;

function FP_getPlayState(clipName, doc)
{
	if (doc == null) doc = document;
	var clipRef = FP_checkClipRef(clipName, "FP_getPlayState", doc);
	if (clipRef == null)
	{
		if (FP_debug)
			alert("In call to FP_getPlayState():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return FP_STOPPED;
	}
	if (clipRef.IsPlaying())
	{
		return FP_PLAYING;
	}
	else
	{
		return FP_STOPPED;
	}
}

function FP_isPlaying(clipName, doc)
{
	if (doc == null) doc = document;
	var clipRef = FP_checkClipRef(clipName, "FP_isPlaying", doc);
	if (clipRef == null)
	{
		if (FP_debug)
			alert("In call to FP_isPlaying():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return false;
	}
	return clipRef.IsPlaying();
}

function FP_getSource(clipName, doc)
{
	if (doc == null) doc = document;
	var clipRef = FP_checkClipRef(clipName, "FP_getSource", doc);
	if (clipRef == null)
	{
		if (FP_debug)
			alert("In call to FP_getSource():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return "";
	}
	return FP_cleanupURL(clipRef.TGetProperty("/",15));
}

function FP_setSource(clipName, url, doc)
{
	if (doc == null) doc = document;
	var clipRef = FP_checkClipRef(clipName, "FP_setSource", doc);
	if (clipRef == null)
	{
		if (FP_debug)
			alert("In call to FP_setSource():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return;
	}
	
	clipRef.LoadMovie(0, url);
}

function FP_getLength(clipName, doc)
{
	if (doc == null) doc = document;
	var clipRef = FP_checkClipRef(clipName, "FP_getLength", doc);
	if (clipRef == null)
	{
		if (FP_debug)
			alert("In call to FP_getLength():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return 0;
	}
	if (FP_inIe4)
	{
		return Math.round(clipRef.TotalFrames/12*1000);
	}
	else
	{
		return Math.round(clipRef.TotalFrames()/12*1000);
	}
}

function FP_setSourcePlay(clipName, url, doc)
{
	if (doc == null) doc = document;
	var clipRef = FP_checkClipRef(clipName, "FP_setSourcePlay", doc);
	if (clipRef == null)
	{
		if (FP_debug)
			alert("In call to FP_setSourcePlay():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return;
	}
	FP_setSource(clipRef,url);
	FP_play(clipRef);
}

var FP_ClipHash = new HashTable();
function FP_play(clipName, doc)
{
	if (doc == null) doc = document;
	var clipRef = FP_checkClipRef(clipName, "FP_play", doc);
	if (clipRef == null)
	{
		if (FP_debug)
			alert("In call to FP_play():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return;
	}
	FP_currentClip = clipRef;
	if (typeof(clipName) == "object")
	{
		clipName = clipName.name;
	}
	FP_ClipHash.put(clipName,clipRef);
	FP_stopAllClips();
	FP_tryToPlay();
}

var FP_currentClip = null;
function FP_tryToPlay()
{
	if (FP_currentClip.PercentLoaded() == 100)
	{
		FP_currentClip.Play();
	}
	else
	{
		setTimeout("FP_tryToPlay()",250);
	}
}

function FP_stop(clipName, doc)
{
	if (doc == null) doc = document;
	var clipRef = FP_checkClipRef(clipName, "FP_stop", doc);
	if (clipRef == null)
	{
		if (FP_debug)
			alert("In call to FP_stop():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return;
	}
	clipRef.GotoFrame(0);
	clipRef.StopPlay();
}

function FP_pause(clipName, doc)
{
	if (doc == null) doc = document;
	var clipRef = FP_checkClipRef(clipName, "FP_stop", doc);
	if (clipRef == null)
	{
		if (FP_debug)
			alert("In call to FP_pause():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return;
	}
	clipRef.StopPlay();
}

function FP_getPosition(clipName, doc)
{
	if (doc == null) doc = document;
	var clipRef = FP_checkClipRef(clipName, "FP_getPosition", doc);
	if (clipRef == null)
	{
		if (FP_debug)
			alert("In call to FP_getPosition():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return 0;
	}
	return Math.round(clipRef.TCurrentFrame("/")/12*1000);
}

function FP_setPosition(clipName, pos, doc)
{
	if (doc == null) doc = document;
	var clipRef = FP_checkClipRef(clipName, "FP_setPosition", doc);
	if (clipRef == null)
	{
		if (FP_debug)
			alert("In call to FP_setPosition():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return;
	}
	clipRef.GotoFrame(pos*12/1000);
}

function FP_checkClipRef(clipRef, functionName, doc)
{
	if (doc == null) doc = document;
	if (arguments.length < 3)
	{
		doc = document;
	}

	if ( typeof(clipRef) == 'string' )
	{
		return FP_getClipRef(clipRef, doc);
	}
	else
	{
		if ( typeof(clipRef) != 'object')
		{
			return null;
		}
	}
	return clipRef;
}

function FP_getClipRef(clipName, doc)
{
	recCount = 0;
	if (arguments.length < 2)
	{
		doc = document;
	}
	
	return FP_getClipRef2(clipName, doc);
}

function FP_getClipRef2(clipName, doc)
{
	var clipRef = null;	
	
	// Base Case 1
	if (navigator.appName == "Microsoft Internet Explorer") 
	{
		clipRef = eval("doc." + clipName);
		return clipRef;
	}

	// Base Case 2
	if (recCount++ >= 100) 
	{
		return null;
	}	

	// Base Case 3
	if (doc.embeds.length > 0) // look for embed in the document	
	{
		if (doc.embeds[clipName] != null) 
		{
			clipRef = doc.embeds[clipName];
			return clipRef;
		}			
	}	

	if (inNetscape6)
	{
		return doc.getElementById(clipName);
	}
	else
	{	
		// Possible Recursion	
		for (var i=0;i<doc.layers.length;i++) // for each layer in the document
		{
			//alert("You have found layer: " + doc.layers[i].id);
			if (doc.layers[i].document.embeds.length > 0)
			{
				if (doc.layers[i].document.embeds[clipName] != null) 
				{
					clipRef = doc.layers[i].document.embeds[clipName];
					return clipRef;
				}
			}
			if (doc.layers[i].document.layers.length > 0) 
				if ( (clipRef = FP_getClipRef2(clipName,doc.layers[i].document)) != null ) 
					break;
		}
	}
	
	return clipRef;
}

// Not implemented
function FP_setVolume()
{
}

// Not implemented
function FP_getVolume()
{
	return 100;
}

function FP_cleanupURL(url)
{
	url = url + "";
	for (var i=0;i<url.length;i++)
	{
		if (url.charCodeAt(i) < 32 || url.charCodeAt(i) > 126)
		{
			url = url.slice(0,i) + url.slice(i+1,url.length);
		} 
		else if (url.charAt(i) == "\\")
		{
			url = url.slice(0,i) + "/" + url.slice(i+1,url.length);
		}
	}
	return url;
}

function FP_stopAllClips()
{
	if (FP_ClipHash != null)
	{
		var keyArray = FP_ClipHash.getKeys();
		for (var i=0;i<keyArray.length;i++)
		{
			FP_stop(keyArray[i]);
		}
	}

	if (window.audioReference != null)
	{
		window.audioReference.stop();
	}
}

